using System;
using System.Collections.Generic;
using System.Text;
using System.Linq;
using VIRP.AHOBPR.BO;
using VIRP.AHOBPR.DAL;

namespace VIRP.AHOBPR.BLL
{
	public static partial class REGISTRANTManager
	{
		#region Fields
		#endregion

		#region Properties
		#endregion

		#region Methods

		public static REGISTRANT GetItem(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 REGISTRANT_ID)
		{
			REGISTRANT objReturn = null;
			REGISTRANTDB objDB = new REGISTRANTDB();

			objReturn = objDB.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, REGISTRANT_ID);

			return objReturn;
		}

        public static REGISTRANT GetItemByUserId(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 USER_ID)
        {
            REGISTRANT objReturn = null;
            REGISTRANTDB objDB = new REGISTRANTDB();

            objReturn = objDB.GetItemByUserId(CURRENT_USER, CURRENT_REGISTRY_ID, USER_ID);

            return objReturn;
        }

        public static REGISTRANT GetItemByEdipi(string EDIPI)
        {
            REGISTRANT objReturn = null;
            REGISTRANTDB objDB = new REGISTRANTDB();

            objReturn = objDB.GetItemByEdipi(EDIPI);

            return objReturn;
        }

        public static REGISTRANT GetRegistrantById(string EDIPI, string SNUM)
        {
            REGISTRANT objReturn = null;
            REGISTRANTDB objDB = new REGISTRANTDB();

            objReturn = objDB.GetRegistrantById(EDIPI, SNUM);

            return objReturn;
        }

        public static string GetUserIdByRegistrantId(Int32 REGISTRANT_ID)
        {
            string objReturn = string.Empty;

            REGISTRANT registrant = GetItem(string.Empty, 0, REGISTRANT_ID);
            if (registrant != null)
                objReturn = registrant.USER_ID;

            return objReturn;
        }

        public static List<REGISTRANT> GetItems(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
		{
			List<REGISTRANT> objReturn = null;
			REGISTRANTDB objDB = new REGISTRANTDB();

			objReturn = objDB.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);

			return objReturn;
		}

        public static List<REGISTRANT> GetItemsByStatus(string REGISTRANT_STATUS)
        {
            List<REGISTRANT> objReturn = null;
            REGISTRANTDB objDB = new REGISTRANTDB();

            objReturn = objDB.GetItemsByStatus(REGISTRANT_STATUS);

            return objReturn;
        }

        public static Int32 Save(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, REGISTRANT objSave)
		{
			Int32 objReturn = 0;
			REGISTRANTDB objDB = new REGISTRANTDB();

			objReturn = objDB.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);

			return objReturn;
		}

		public static Boolean Delete(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 REGISTRANT_ID)
		{
			Boolean objReturn = false;
			REGISTRANTDB objDB = new REGISTRANTDB();

			objReturn = objDB.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, REGISTRANT_ID);

			return objReturn;
		}

		public static Boolean Delete(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, REGISTRANT objDelete)
		{
			return Delete(CURRENT_USER, CURRENT_REGISTRY_ID, objDelete.REGISTRANT_ID);
		}

        public static int UpdateRegistrant(REGISTRANT registrant)
        {
            return UpdateRegistrant(registrant, 1);
        }

        private static int UpdateRegistrant(REGISTRANT registrant, int tryCount)
        {
            if (tryCount >= 20)
            {
                LogManager.LogError("Unable to save JSON Data after 20 tries: {UserId:" + registrant.USER_ID + "}", String.Format("{ 0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), string.Empty, 0);
                //_sharedManager.LogErrorMessage("Exception", this.GetType().Name + "." + MethodBase.GetCurrentMethod().Name,
                //    "Unable to save JSON Data after 20 tries: {UserId:" + registrant.USER_ID + "}");

                return -1;
            }
            if (tryCount > 1)
            {
                LogManager.LogError("retry #" + tryCount.ToString() + ": {UserId:" + registrant.USER_ID + "}", String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), string.Empty, 0);
                //_sharedManager.LogErrorMessage("Retry", this.GetType().Name + "." + MethodBase.GetCurrentMethod().Name,
                //    "retry #" + tryCount.ToString() + ": {UserId:" + registrant.USER_ID + "}");
            }

            int returnStatus = 0;

            if (registrant != null)
            {
                try
                {
                    registrant.REGISTRANT_ID = Save(string.Empty, 0, registrant);
                    returnStatus = 1;
                }
                catch (System.Data.SqlClient.SqlException ex)
                {
                    LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), string.Empty, 0);
                    //_sharedManager.LogErrorMessage("Sql Exception", this.GetType().Name + "." + MethodBase.GetCurrentMethod().Name, "UserId: " + registrant.USER_ID + " Error: " + ex.Message);
                    returnStatus = UpdateRegistrant(registrant, tryCount + 1);
                }
                catch (Exception ex)
                {
                    LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), string.Empty, 0);
                    //_sharedManager.LogErrorMessage("Database Update", this.GetType().Name + "." + MethodBase.GetCurrentMethod().Name, "UserId: " + registrant.USER_ID + " Error: " + ex.Message);
                    returnStatus = UpdateRegistrant(registrant, tryCount + 1);
                }

                //using (_dbAhobpr = GetLocalContext(_connectionInfo))
                //{
                //    _dbAhobpr.DeferredLoadingEnabled = false;

                //    //this line traverses all entities, attaching all of them as appropriate to the data context.
                //    registrant.SynchroniseWithDataContext(_dbAhobpr);

                //    //Check if any actual changes will occur
                //    ChangeSet changeSet = _dbAhobpr.GetChangeSet();

                //    if (changeSet.Updates.Count > 0 || changeSet.Inserts.Count > 0)
                //    {
                //        //if changes present then submit changes
                //        try
                //        {
                //            _dbAhobpr.SubmitChanges(ConflictMode.ContinueOnConflict);
                //            returnStatus = 1;

                //        }
                //        catch (System.Data.SqlClient.SqlException ex)
                //        {
                //            LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), string.Empty, 0);
                //            //_sharedManager.LogErrorMessage("Sql Exception", this.GetType().Name + "." + MethodBase.GetCurrentMethod().Name, "UserId: " + registrant.USER_ID + " Error: " + ex.Message);
                //            returnStatus = UpdateRegistrant(registrant, tryCount + 1);
                //        }
                //        //catch (ChangeConflictException ex)
                //        //{
                //        //    LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), string.Empty, 0);
                //        //    //_dbAhobpr.ChangeConflicts.ResolveAll(RefreshMode.KeepChanges);
                //        //    //_sharedManager.LogErrorMessage("Database Update", this.GetType().Name + "." + MethodBase.GetCurrentMethod().Name, "UserId: " + registrant.USER_ID + " Error: " + ex.Message);

                //        //    returnStatus = UpdateRegistrant(registrant, tryCount + 1);
                //        //}
                //        catch (Exception ex)
                //        {
                //            LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), string.Empty, 0);
                //            //_sharedManager.LogErrorMessage("Database Update", this.GetType().Name + "." + MethodBase.GetCurrentMethod().Name, "UserId: " + registrant.USER_ID + " Error: " + ex.Message);
                //            returnStatus = UpdateRegistrant(registrant, tryCount + 1);
                //        }
                //    }
                //}
            }
            return returnStatus;
        }

        public static string UpdateAll(string EDIPI, Int32 REGISTRANT_ID)
        {
            string objReturn = string.Empty;

            var result = new StringBuilder();
            result.Append($"{REGISTRANT_ID},");

            //TLB.TODO

            //string status = REGISTRANT_RETIREMENTManager.Update(EDIPI, REGISTRANT_ID);
            //result.Append($"Retirement:{status},");

            //status = VeteranStatusManager.Update(EDIPI, REGISTRANT_ID);
            //result.Append($"VeteranStatus:{status},");

            //status = MilitaryServiceEpisodeManager.Update(EDIPI, REGISTRANT_ID);
            //result.Append($"Service Episodes:{status},");

            //status = RegistrantDeploymentManager.Update(EDIPI, REGISTRANT_ID);
            //result.Append($"DeploymentImporter:{status},");




            //foreach (IUpdateManager manager in updateManagers)
            //{
            //    var status = manager.Update(EDIPI, REGISTRANT_ID);
            //    result.Append($"{manager.Name}:{status},");
            //}

            result.Length -= 1;
            objReturn = result.ToString();

            return objReturn;
        }

        public static string GetTotalParticipants()
        {
            int totalParticipants = 0;

            List<REGISTRANT> objTemp = GetItemsByStatus("Participant");
            if (objTemp != null)
                totalParticipants = objTemp.Count;

            //using (_dbAhobpr = GetDataContext())
            //{
            //    totalParticipants = (from e in _dbAhobpr.REGISTRANTs
            //                         where e.STD_REGISTRANT_STATUS_ID == (int)Enums.RegistrantStatus.Participant
            //                         select e.REGISTRANT_ID).Count();

            //}
            return totalParticipants.ToString("N0");
        }

        public static List<string> PdfRegistrantList(DateTime startDate, DateTime endDate)
        {
            List<string> objReturn = null;
            REGISTRANTDB objDB = new REGISTRANTDB();

            objReturn = objDB.PdfRegistrantList(startDate, endDate);

            return objReturn;
        }

        public static string GetPdfMetaData(string USER_ID)
        {
            string objReturn = string.Empty;
            REGISTRANTDB objDB = new REGISTRANTDB();

            objReturn = objDB.GetPdfMetaData(USER_ID);

            return objReturn;
        }

        public static int AddFollowupQuestionsToOneReigstrant(int registrantId, int followupFormId, ref bool exists)
        {
            int returnStatus = 0;
            if (registrantId == 0 || followupFormId == 0)
            {
                return returnStatus;
            }

            List<FOLLOWUP_FORM_RESPONSE> responses = FOLLOWUP_FORM_RESPONSEManager.GetItemsByRegistrant(string.Empty, 0, registrantId);
            if (responses != null)
            {
                //_dbAhobpr.DeferredLoadingEnabled = false;

                //check if registry flag exists
                FOLLOWUP_FORM_RESPONSE followupFormResponse = (from e in responses
                                                               where e.STD_FORM_ID == followupFormId
                                                               select e).FirstOrDefault();

                //insert if not exists
                if (followupFormResponse == null)
                {
                    exists = false;
                    followupFormResponse = new FOLLOWUP_FORM_RESPONSE();

                    followupFormResponse.REGISTRANT_ID = registrantId;
                    followupFormResponse.STD_FORM_ID = followupFormId;

                    //_dbAhobpr.FOLLOWUP_FORM_RESPONSEs.InsertOnSubmit(followupFormResponse);

                    try
                    {
                        followupFormResponse.FOLLOWUP_FORM_RESPONSE_ID = FOLLOWUP_FORM_RESPONSEManager.Save(string.Empty, 0, followupFormResponse);
                        //_dbAhobpr.SubmitChanges(ConflictMode.ContinueOnConflict);

                        returnStatus = 1;
                    }
                    catch (System.Data.SqlClient.SqlException ex)
                    {
                        LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), string.Empty, 0);
                        //_sharedManager.LogErrorMessage("Sql Exception", this.GetType().Name + "." + MethodBase.GetCurrentMethod().Name, ex.Message);
                        returnStatus = -1;
                    }
                    //catch (ChangeConflictException)
                    //{
                    //    _dbAhobpr.ChangeConflicts.ResolveAll(RefreshMode.KeepCurrentValues);

                    //    try
                    //    {
                    //        _dbAhobpr.SubmitChanges(ConflictMode.FailOnFirstConflict);

                    //        returnStatus = 1;
                    //    }
                    //    catch (Exception ex)
                    //    {
                    //        _sharedManager.LogErrorMessage("Database Update", this.GetType().Name + "." + MethodBase.GetCurrentMethod().Name, ex.Message);
                    //        returnStatus = -1;
                    //    }
                    //}
                    catch
                    {
                        returnStatus = 0;
                    }

                }
                // if the registry flag already exists, ignore and consider as success insert
                else
                {
                    exists = true;
                    returnStatus = 1;
                }
            }

            return returnStatus;
        }

        public static int AddFlagToRegistrantByFlagName(int registrantId, string registryFlagName, string createdBy)
        {
            int result = 0;

            int registryFlagId = GetRegistryFlagIdByName(registryFlagName);
            if (registryFlagId == 0)
            {
                AddRegistryFlag((int)Enums.AhobprRegistryFlagType.AdminFlag, registryFlagName, registryFlagName, createdBy);
                registryFlagId = GetRegistryFlagIdByName(registryFlagName);
            }
            if (registryFlagId > 0)
            {
                result = AddFlagToRegistrantByFlagId(registrantId, registryFlagId, createdBy);
            }

            return result;
        }

        public static int GetRegistryFlagIdByName(string registryFlagName)
        {
            int result = 0;

            STD_REGISTRY_FLAG flag = STD_REGISTRY_FLAGManager.GetItemByName(string.Empty, 0, registryFlagName);
            if (flag != null)
                result = flag.STD_REGISTRY_FLAG_ID;

            return result;
        }

        public static bool HasSubpopulationFlag(int registrantId, int registryFlagId)
        {
            return REGISTRANT_REGISTRY_FLAGManager.HasSubpopulationFlag(registrantId, registryFlagId);

            //bool hasSubpopulationFlag = false;

            //using (_dbAhobpr = GetDataContext())
            //{
            //    hasSubpopulationFlag = (from e in _dbAhobpr.REGISTRANT_REGISTRY_FLAGs
            //                            where e.REGISTRANT_ID == registrantId
            //                                && e.STD_REGISTRY_FLAG_ID == registryFlagId
            //                                && e.STD_REGISTRY_FLAG.STD_REGISTRY_FLAG_TYPE_ID == (int)Enums.AhobprRegistryFlagType.SubpopulationFlag
            //                            select e).ToList().Count > 0;
            //}

            //return hasSubpopulationFlag;
        }

        public static int AddFlagToRegistrantByFlagId(int registrantId, int registryFlagId, string createdBy)
        {
            int returnStatus = 0;

            if (registryFlagId == 0 || registrantId == 0)
            {
                return returnStatus;
            }

            //using (_dbAhobpr = GetDataContext())
            //{
            //    _dbAhobpr.DeferredLoadingEnabled = false;

                REGISTRANT_REGISTRY_FLAG registrantflag = new REGISTRANT_REGISTRY_FLAG();

                registrantflag.REGISTRANT_ID = registrantId;
                registrantflag.STD_REGISTRY_FLAG_ID = registryFlagId;
                registrantflag.CREATEDBY = createdBy;
                registrantflag.UPDATEDBY = createdBy;

                //_dbAhobpr.REGISTRANT_REGISTRY_FLAGs.InsertOnSubmit(registrantflag);

                try
                {
                    registrantflag.REGISTRANT_REGISTRY_FLAG_ID = REGISTRANT_REGISTRY_FLAGManager.Save(string.Empty, 0, registrantflag);
                    //_dbAhobpr.SubmitChanges(ConflictMode.ContinueOnConflict);

                    returnStatus = 1;
                }
                catch (System.Data.SqlClient.SqlException ex)
                {
                    LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), string.Empty, 0);
                    //_sharedManager.LogErrorMessage("Sql Exception", this.GetType().Name + "." + MethodBase.GetCurrentMethod().Name, ex.Message);
                    returnStatus = -1;
                }
                //catch (ChangeConflictException)
                //{
                //    _dbAhobpr.ChangeConflicts.ResolveAll(RefreshMode.KeepCurrentValues);

                //    try
                //    {
                //        _dbAhobpr.SubmitChanges(ConflictMode.FailOnFirstConflict);

                //        returnStatus = 1;
                //    }
                //    catch (Exception ex)
                //    {
                //        _sharedManager.LogErrorMessage("Database Update", this.GetType().Name + "." + MethodBase.GetCurrentMethod().Name, ex.Message);
                //        returnStatus = -1;
                //    }
                //}
                catch
                {
                    returnStatus = 0;
                }
            //}
            return returnStatus;
        }

        public static int AddRegistryFlag(int registryFlagTypeId, string registryFlagName, string registryFlagDescription, string createdBy)
        {
            int returnStatus = 0;

            if (string.IsNullOrEmpty(registryFlagName))
            {
                return returnStatus;
            }

            //using (_dbAhobpr = GetDataContext())
            //{
            //_dbAhobpr.DeferredLoadingEnabled = false;

            //check if registry flag exists
            STD_REGISTRY_FLAG registryFlag = STD_REGISTRY_FLAGManager.GetItemByName(string.Empty, 0, registryFlagName);
            //STD_REGISTRY_FLAG registryFlag = (from e in _dbAhobpr.STD_REGISTRY_FLAGs
            //                                  where e.REGISTRY_FLAG_NAME == registryFlagName
            //                                  select e).FirstOrDefault();

            //insert if not exists
            if (registryFlag == null)
            {
                registryFlag = new STD_REGISTRY_FLAG();

                registryFlag.STD_REGISTRY_FLAG_TYPE_ID = registryFlagTypeId;
                registryFlag.REGISTRY_FLAG_NAME = registryFlagName;
                registryFlag.REGISTRY_FLAG_DESCRIPTION = registryFlagDescription;
                //set active_Flag to false so the admin flags don't show up in the dropdownlist for automatic generated sent messages
                registryFlag.ACTIVE_FLAG = true;
                registryFlag.PREDEFINED = true;
                registryFlag.CREATEDBY = createdBy;
                registryFlag.UPDATEDBY = createdBy;

                //_dbAhobpr.STD_REGISTRY_FLAGs.InsertOnSubmit(registryFlag);

                try
                {
                    registryFlag.STD_REGISTRY_FLAG_ID = STD_REGISTRY_FLAGManager.Save(string.Empty, 0, registryFlag);
                    //_dbAhobpr.SubmitChanges(ConflictMode.ContinueOnConflict);

                    returnStatus = 1;
                }
                catch (System.Data.SqlClient.SqlException ex)
                {
                    LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), string.Empty, 0);
                    //_sharedManager.LogErrorMessage("Sql Exception", this.GetType().Name + "." + MethodBase.GetCurrentMethod().Name, ex.Message);
                    returnStatus = -1;
                }
                //catch (ChangeConflictException)
                //{
                //    _dbAhobpr.ChangeConflicts.ResolveAll(RefreshMode.KeepCurrentValues);

                //    try
                //    {
                //        _dbAhobpr.SubmitChanges(ConflictMode.FailOnFirstConflict);
                //        returnStatus = 1;
                //    }
                //    catch (Exception ex)
                //    {
                //        _sharedManager.LogErrorMessage("Database Update", this.GetType().Name + "." + MethodBase.GetCurrentMethod().Name, ex.Message);
                //        returnStatus = -1;
                //    }
                //}
                catch
                {
                    returnStatus = 0;
                }

            }
            // if the registry flag already exists, set returnStatus to 2
            else
            {
                returnStatus = 2;
            }
            //}
            return returnStatus;
        }

        public static REGISTRANT GetRegistrantByUserIdWithFollowupResponse(string USER_ID)
        {
            REGISTRANT reg = null;
            int temp = 0;
            if (int.TryParse(USER_ID, out temp))
            {
                reg = GetItemByUserId(string.Empty, 0, temp);

                if (reg != null)
                {
                    reg.FOLLOWUP_FORM_RESPONSEs = FOLLOWUP_FORM_RESPONSEManager.GetItemsByRegistrant(string.Empty, 0, reg.REGISTRANT_ID);
                }
            }

            return reg;
        }

        public static bool ResetDatabase()
        {
            bool result = true;
            REGISTRANTDB objDB = new REGISTRANTDB();

            result = objDB.ResetDatabase();

            return result;
        }

        public static bool DeleteOneRegistrant(int REGISTRANT_ID)
        {
            bool result = true;
            REGISTRANTDB objDB = new REGISTRANTDB();

            result = objDB.DeleteOneRegistrant(REGISTRANT_ID);

            return result;
        }

        #endregion
    }
}
